CREATE TABLE CD_Motivos
(Id_CD_Motivo			INT				IDENTITY(300,1),
Activo					TINYINT			NOT NULL,	/*Si Flag_Sistema = 1 no se puede modificar*/
Flag_Sistema			TINYINT			NOT NULL,	/*1: Generado por CleverSoft, no se pueden borrar*/
Tipo  					CHAR(1)			NOT NULL,	/*H: Habilitacion. R: Rechazo*/
Descripcion				VARCHAR(5000)	NOT NULL,	/*Para grabar en Observacion de CD_ES, si Flag_Sistema = 1 no se permiten cambiar*/
Descripcion_Display		VARCHAR(32),				/*Para mostrar en Displays chicos  (puede personalizarla el cliente, aunque Flag_Sistema = 1), si es vacio se utilizar Descripcion*/
Descripcion_Pantalla	VARCHAR(100)				/*Para mostrar en Displays grandes (puede personalizarla el cliente, aunque Flag_Sistema = 1), si es vacio se utilizar Descripcion*/

CONSTRAINT PK_CDMot PRIMARY KEY (Id_CD_Motivo)
)
GO

---------------------------------------------------------------------------------------------------------------------------------------------------

SET IDENTITY_INSERT dbo.CD_Motivos ON;

/*Predefinidos de ClaverSoft*/
INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (0, 0, 1, 'R', 'NO DEFINIDO')
GO

/*Rechazos*/
INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (101, 1, 1, 'R', 'No se enviaron datos de validacion')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (102, 1, 1, 'R', 'El Acceso no existe')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (103, 1, 1, 'R', 'La Persona invlida')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (104, 1, 1, 'R', 'La Persona desactivada')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (105, 1, 1, 'R', 'Rechazo por Tipo de Venc.')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (106, 1, 1, 'R', 'Rechazo por Tipo de Contrato')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (107, 1, 1, 'R', 'Rechazo por Categoria')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (108, 1, 1, 'R', 'Ya ingresado. Antipassback')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (109, 1, 1, 'R', 'No Registro Salida. Antipassback')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (110, 1, 1, 'R', 'No Registro Entrada. Antipassback')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (111, 1, 1, 'R', 'No posee foto')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (112, 1, 1, 'R', 'No cumple ninguna condicin habilitante')
GO

/*Habilitaciones*/
INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (201, 1, 1, 'H', 'Ingreso por Ticket Import.')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (202, 1, 1, 'H', 'Acceso Master')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (203, 1, 1, 'H', 'La Persona con UCP al da')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (204, 1, 1, 'H', 'Habilit. por Tipo de Contrato')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (205, 1, 1, 'H', 'Habilit. por Tipo de Cliente')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (206, 1, 1, 'H', 'Habilit. por Produc. Comprado')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (207, 1, 1, 'H', 'Habilit. por Produc. Comprado por Titular')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (208, 1, 1, 'H', 'Habilit. por Evento')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (209, 1, 1, 'H', 'Habilit. por Categoria por horario')
GO

INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (210, 1, 1, 'H', 'Habilit. por Produc. Comprado por horario')
GO

/*Personalizados*/
/*A Partir del 300 son manuales (Flag_Sistema = 0) agregados por los clientes*/
INSERT INTO CD_Motivos (Id_CD_Motivo, Activo, Flag_Sistema, Tipo, Descripcion) VALUES (299, 0, 1, 'R', 'Habilitacion. Reservado CleverSoft')
GO

SET IDENTITY_INSERT CD_Motivos OFF;
GO

---------------------------------------------------------------------------------------------------------------------------------------------------

ALTER TABLE CD_ES ADD Id_CD_Motivo INT
GO

---------------------------------------------------------------------------------------------------------------------------------------------------

CREATE INDEX IX_CDES_CD_Motivos ON CD_ES (Id_CD_Motivo)
GO

ALTER TABLE CD_ES ADD CONSTRAINT FK_CDES_CD_Motivos FOREIGN KEY(Id_CD_Motivo) REFERENCES CD_Motivos (Id_CD_Motivo)
GO